VERSION ("Buzzer 1.0")

'************************************************************************************************************
'
'  Sample Program for BEEP and KEY_CLICK Commands
'
'  Target Machine : CPT-711
'
'  Commands :
' 	BEEP (freq%, duration% {, freq%, duration%}
'	       		  : To make beeper sounds according to the specified beeper sequence.
'			   freq% must be an integer that indicates the value of beep frequence (Hz). 
'				 Suitable frequency for the beeper ranges from 1 kHz to 6 kHz.
'	 		  duration% must be an integer that indicates the value of beep duration.
' 			  	 Beep duration is specified in units of 10 ms.
'
'	KEY_CLICK(status%) : To enable/disable the key click sound.
'				status% may be 1 or 0.
'				0: disable the key click sound.
'				1: enable the key click sound.(default)
'
'************************************************************************************************************

100
	BEEP(1000,5,0,5,2000,10)

	CLS
	SELECT_FONT (1)

	LOCATE 1,4
	PRINT  "[ BUZZER TEST ]"

	LOCATE 3,2
	PRINT  "KEY CLICK SOUND?"

	SELECT_FONT (2)

	LOCATE 6,2
	PRINT  "7>OFF    9>ON"

	CLR_KBD
	LOCATE 6,2

KeySoundSet:

	KeyD$ = INKEY$

	IF KeyD$ = "7" THEN
		KEY_CLICK(0)
		PRINT "SET OFF           "
	ELSE IF KeyD$ = "9" THEN
		KEY_CLICK(1)
		PRINT "SET ON            "
	ELSE
		GOTO KeySoundSet
	END IF

	WAIT (500)

	GOTO 100		
		